/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.launch.hscmgt;

import com.ibm.hsc.auiml.databeans.datetime.CustomizeHMCDateTimeLinkData;
import com.ibm.hsc.cim.exceptions.HSCException;
import com.ibm.hsc.client.rmc.HSCRMCUtil;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.Crypt;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.launch.hscmgt.hscDateTime;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import com.ibm.websm.etc.EWorkingListener;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.mobject.MOXReference;
import com.ibm.websm.mobject.MObjectImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class SystemConfigurationOverview
extends MObjectImpl {
    private static final String TRACE_MASKD = "JSYCOOVD";
    private static final String TRACE_MASKF = "JSYCOOVF";
    private static final String TRACE_MASKT = "JSYCOOVT";
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, 113, "SystemConfigurationOverview");
    private static HashMap _localeTable = null;
    private static final String SPACE = "   ";

    public SystemConfigurationOverview(String string) throws Throwable {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SystemConfigurationOverview.SystemConfigurationOverview()");
        }
        this.setKey(string);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SystemConfigurationOverview.SystemConfigurationOverview()");
        }
    }

    public static String getClassName() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SystemConfigurationOverview.getClassName()");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SystemConfigurationOverview.getClassName()");
        }
        return "SystemConfigurationOverview";
    }

    public static MObjectImpl getInstance(MOXReference mOXReference) throws Throwable {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SystemConfigurationOverview.getInstance()");
        }
        String string = mOXReference.getKey();
        SystemConfigurationOverview systemConfigurationOverview = new SystemConfigurationOverview(string);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SystemConfigurationOverview.getInstance()");
        }
        return systemConfigurationOverview;
    }

    public static CustomizeHMCDateTimeLinkData GetHMCTimeW() throws Throwable {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SystemConfigurationOverview.GetHMCTimeW()");
        }
        CustomizeHMCDateTimeLinkData customizeHMCDateTimeLinkData = hscDateTime.GetHMCTime();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SystemConfigurationOverview.GetHMCTimeW()");
        }
        return customizeHMCDateTimeLinkData;
    }

    public static void SetHMCTimeW(CustomizeHMCDateTimeLinkData customizeHMCDateTimeLinkData) throws Throwable {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SystemConfigurationOverview.SetHMCTimeW()");
        }
        hscDateTime.SetHMCTime(customizeHMCDateTimeLinkData);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SystemConfigurationOverview.SetHMCTimeW()");
        }
    }

    public static Vector ReadTimeZoneListW() throws Throwable {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SystemConfigurationOverview.ReadTimeZoneListW()");
        }
        Vector vector = hscDateTime.ReadTimeZoneList();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SystemConfigurationOverview.ReadTimeZoneListW()");
        }
        return vector;
    }

    public static String GetCurrentTimeZoneW() throws Throwable {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SystemConfigurationOverview.GetCurrentTimeZoneW()");
        }
        String string = hscDateTime.GetCurrentTimeZone();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SystemConfigurationOverview.GetCurrentTimeZoneW()");
        }
        return string;
    }

    public static void SetCurrentTimeZoneW(String string) throws Throwable {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SystemConfigurationOverview.SetCurrentTimeZoneW()");
        }
        hscDateTime.SetCurrentTimeZone(string);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SystemConfigurationOverview.SetCurrentTimeZoneW()");
        }
    }

    public static void ApacheSetup() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SystemConfigurationOverview.ApacheSetup()");
        }
        EExecResult eExecResult = EExec.Exec((String)("/opt/hsc/bin/hscdc " + Crypt.encrypt("/opt/hsc/bin/apache_setup")));
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SystemConfigurationOverview.ApacheSetup()");
        }
    }

    private static StringBuffer parseTargetString(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer("");
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '\\') {
                stringBuffer.append(c);
                stringBuffer.append(c);
                stringBuffer.append(c);
            } else if (c == '`' || c == '$' || c == '\"' || c == '\'' || c == ';' || c == '|' || c == '<' || c == '>' || c == '(' || c == ')' || c == '&') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            c = stringCharacterIterator.next();
        }
        return stringBuffer;
    }

    public static void doNetworkChecking(String string, EWorkingListener eWorkingListener) {
        if (eWorkingListener != null) {
            eWorkingListener.showDialog(true);
        }
        StringBuffer stringBuffer = SystemConfigurationOverview.parseTargetString(string);
        EExecResult eExecResult = EExec.Exec((String)("echo -E " + stringBuffer + " | xargs /bin/ping -c 5 -w 60 "), (EWorkingListener)eWorkingListener);
        if (eWorkingListener != null) {
            eWorkingListener.eof(eExecResult.rc);
        }
    }

    public static Integer doRemoteAccess(Boolean bl, EWorkingListener eWorkingListener) {
        if (eWorkingListener != null) {
            eWorkingListener.showDialog(true);
        }
        if (IDebug.enabled) {
            System.err.println("SSH enablement " + bl);
        }
        EExecResult eExecResult = null;
        if (bl != null) {
            eExecResult = bl != false ? EExec.Exec((String)("/opt/hsc/bin/hscdc " + Crypt.encrypt("/etc/rc.d/hmcsshd") + " force_start")) : EExec.Exec((String)("/opt/hsc/bin/hscdc " + Crypt.encrypt("/etc/rc.d/hmcsshd") + " force_stop"));
        }
        if (IDebug.enabled) {
            System.err.println("Remote Access  OUTPUT " + eExecResult.getStdout());
            System.err.println("Remote Access  ERROR " + eExecResult.getStderr());
        }
        if (eWorkingListener != null) {
            eWorkingListener.showDialog(false);
        }
        if (eExecResult != null) {
            return new Integer(eExecResult.getRc());
        }
        return new Integer(1);
    }

    public static Boolean sshEnabled() {
        EExecResult eExecResult = EExec.Exec((String)("/opt/hsc/bin/hscdc " + Crypt.encrypt("/etc/rc.d/hmcsshd") + " status"));
        if (eExecResult.rc == 0) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    static String executeCommandGetStdOut(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SystemConfigurationOverview.executeCommandGetStdOut()");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "   about to attempt " + string);
        }
        String string2 = "";
        EExecResult eExecResult = EExec.Exec((String)string);
        string2 = eExecResult.stdout;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SystemConfigurationOverview.executeCommandGetStdOut()");
        }
        return string2;
    }

    static void executeCommand(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SystemConfigurationOverview.executeCommand()");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "   about to attempt " + string);
        }
        String string2 = "";
        EExecResult eExecResult = EExec.Exec((String)string);
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "-- command rc = <" + eExecResult.rc + ">, stdout is <" + eExecResult.stdout.trim() + ">");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SystemConfigurationOverview.executeCommand()");
        }
    }

    public static void remoteVterm(Boolean bl, EWorkingListener eWorkingListener) throws Throwable {
        boolean bl2 = false;
        EExecResult eExecResult = null;
        try {
            if (IDebug.enabled) {
                System.out.println("remoteVtermEnabled = " + bl);
            }
            if (eWorkingListener != null) {
                eWorkingListener.showDialog(true);
            }
            File file = new File("/var/hsc/vterm/", "vtermon");
            File file2 = new File("/var/hsc/vterm/");
            if (bl != null) {
                if (bl.booleanValue()) {
                    bl2 = true;
                    if (!file.exists()) {
                        if (!file2.exists()) {
                            EExec.Exec((String)("/opt/hsc/bin/hscdc " + Crypt.encrypt("mkdir") + " -p " + "/var/hsc/vterm/"));
                        }
                        eExecResult = EExec.Exec((String)("/opt/hsc/bin/hscdc " + Crypt.encrypt("touch") + " " + "/var/hsc/vterm/vtermon"));
                    }
                } else {
                    bl2 = false;
                    if (file.exists()) {
                        eExecResult = EExec.Exec((String)("/opt/hsc/bin/hscdc " + Crypt.encrypt("rm") + " -rf " + "/var/hsc/vterm/vtermon"));
                    }
                }
            }
            try {
                String[] stringArray = new String[]{bl2 ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ENABLED", "enabled") : HSCResourceBundleUtil.getMessage("HSCCommonBundle", "DISABLED", "disabled")};
                String string = stringArray[0] + " remote virtual terminal connections";
                HSCLogUtils.logSystemEvent((short)2070, string, stringArray, HSCLogUtils.getUserName((MOClass)SystemConfigurationOverview.getMOClassImpl((String)"com.ibm.hsc.websm.launch.hscmgt.SystemConfigurationOverview")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (eWorkingListener != null) {
                eWorkingListener.showDialog(false);
            }
        }
        catch (Throwable throwable) {
            if (eWorkingListener != null) {
                eWorkingListener.showDialog(false);
            }
            try {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._HSCClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            try {
                String[] stringArray = new String[]{bl2 ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ENABLED", "enabled") : HSCResourceBundleUtil.getMessage("HSCCommonBundle", "DISABLED", "disabled")};
                String string = stringArray[0] + " remote virtual terminal connections failed";
                HSCLogUtils.logSystemEvent((short)2069, string, stringArray, HSCLogUtils.getUserName((MOClass)SystemConfigurationOverview.getMOClassImpl((String)"com.ibm.hsc.websm.launch.hscmgt.SystemConfigurationOverview")));
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw new HSCException("251E");
        }
    }

    public static Boolean remoteVtermEnabled() {
        File file;
        if (IDebug.enabled) {
            System.out.println("remoteVtermEnabled ...");
        }
        if ((file = new File("/var/hsc/vterm/", "vtermon")).exists()) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    public static String getLocale() {
        String string = null;
        EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/getLocaleList -l");
        if (IDebug.enabled) {
            System.err.println(" Locale obtained " + eExecResult.getStdout());
            System.err.println(" Error obtained " + eExecResult.getStderr());
        }
        if (eExecResult.getRc() != 0) {
            string = HSCResourceBundleUtil.getMessage("PlatformBundle", "UNSUPPORTED_LOCALE", "Unsupported Locale");
        } else {
            string = eExecResult.getStdout().trim();
            String string2 = (String)SystemConfigurationOverview.getLocaleTable().get(string);
            string = string2 == null ? HSCResourceBundleUtil.getMessage("PlatformBundle", "UNSUPPORTED_LOCALE", "Unsupported Locale") : string + SPACE + SystemConfigurationOverview.getLocaleTable().get(string);
        }
        return string;
    }

    public static HashMap getLocaleTable() {
        if (_localeTable != null) {
            return _localeTable;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("cs_CZ", "Czech(ISO-8859-2)");
        hashMap.put("de_CH", "German(ISO-8859-1)");
        hashMap.put("de_CH@euro", "German(ISO-8859-15)");
        hashMap.put("de_DE", "German(ISO-8859-1)");
        hashMap.put("de_DE@euro", "German(ISO-8859-15)");
        hashMap.put("en_GB", "Britsh English(ISO-8859-1)");
        hashMap.put("en_US", "US English(ISO-8859-1)");
        hashMap.put("es_ES", "Spanish(ISO-8859-1)");
        hashMap.put("es_ES@euro", "Spanish(ISO-8859-15)");
        hashMap.put("es_LA", "Spanish(ISO-8859-1)");
        hashMap.put("es_LA@euro", "Spanish(ISO-8859-15)");
        hashMap.put("fr_BE", "Belgian French(ISO-8859-1)");
        hashMap.put("fr_BE@euro", "Belgian French(ISO-8859-15)");
        hashMap.put("fr_CA", "Canadian French(ISO-8859-1)");
        hashMap.put("fr_CA@euro", "Canadian French(ISO-8859-15)");
        hashMap.put("fr_CH", "French(ISO-8859-1)");
        hashMap.put("fr_CH@euro", "French(ISO-8859-15)");
        hashMap.put("fr_FR", "French(ISO-8859-1)");
        hashMap.put("fr_FR@euro", "French(ISO-8859-15)");
        hashMap.put("hu_HU", "Hungarian(ISO-8859-2)");
        hashMap.put("it_IT", "Italian(ISO-8859-1)");
        hashMap.put("it_IT@euro", "Italian(ISO-8859-15)");
        hashMap.put("ja_JP", "Japanese(EUC-JP)");
        hashMap.put("ko_KR", "Korean(EUC-KR)");
        hashMap.put("nl_BE", "Belgian Dutch(ISO-8859-1)");
        hashMap.put("nl_BE@euro", "Belgian Dutch(ISO-8859-15)");
        hashMap.put("nl_NL", "Dutch(ISO-8859-1)");
        hashMap.put("nl_NL@euro", "Dutch(ISO-8859-15)");
        hashMap.put("pt_BR", "Brazilian Portuguese(ISO-8859-1)");
        hashMap.put("pt_BR@euro", "Brazilian Portuguese(ISO-8859-15)");
        hashMap.put("ru_RU", "Russian(ISO-8859-5)");
        hashMap.put("sk_SK", "Slovak(ISO-8859-2)");
        hashMap.put("zh_CN", "Simplified Chinese(GB2312)");
        hashMap.put("zh_TW", "Traditional Chinese(BIG5)");
        _localeTable = hashMap;
        return hashMap;
    }

    public static String[] getLocaleList() {
        String[] stringArray = null;
        EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/getLocaleList");
        if (eExecResult.getRc() != 0) {
            stringArray = new String[]{"en_US"};
        } else {
            HashMap hashMap = SystemConfigurationOverview.getLocaleTable();
            String string = eExecResult.getStdout().trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            int n = stringTokenizer.countTokens() + 1;
            stringArray = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || (string2 = (String)hashMap.get(string3)) == null) continue;
                stringArray[n2++] = string3 + SPACE + string2;
            }
            stringArray[n2] = HSCResourceBundleUtil.getMessage("PlatformBundle", "UNSUPPORTED_LOCALE", "Unsupported Locale");
        }
        return stringArray;
    }

    public static Integer setNewLocale(String string) {
        Hashtable hashtable;
        EExecResult eExecResult;
        block9: {
            eExecResult = EExec.Exec((String)("/opt/hsc/bin/setLangOps " + string));
            hashtable = null;
            try {
                hashtable = HSCRMCUtil.runRMCCommand(string);
            }
            catch (Exception exception) {
                if (!IDebug.enabled) break block9;
                System.err.println("Error running RMC command");
            }
        }
        if (hashtable != null) {
            Integer n = (Integer)hashtable.get("Rc");
            if (n != null) {
                if (n != 0 && IDebug.enabled) {
                    System.err.println(" Error return from RMC ");
                }
            } else if (IDebug.enabled) {
                System.err.println(" Rc value from RMC is null");
            }
        } else if (IDebug.enabled) {
            System.err.println("Hashtable from RM command execution is empty");
        }
        return new Integer(eExecResult.getRc());
    }

    public static int setLocaleExitRun() {
        EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/setLangOps -y");
        if (eExecResult.getRc() != 0) {
            return -1;
        }
        return 0;
    }

    public static int setLocaleExitNoRun() {
        EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/setLangOps -n");
        if (eExecResult.getRc() != 0) {
            return -1;
        }
        return 0;
    }

    public static Boolean getMMTaskEnableState() {
        boolean bl;
        boolean bl2;
        Boolean bl3;
        block13: {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "-> RemoteSupportOverview.getMMTaskEnableState()");
            }
            bl3 = Boolean.TRUE;
            bl2 = false;
            bl = false;
            PropertyResourceBundle propertyResourceBundle = null;
            try {
                propertyResourceBundle = new PropertyResourceBundle(new FileInputStream("/opt/hsc/data/hmcType.properties"));
                String string = propertyResourceBundle.getString("HMCTYPE");
                if (!string.equals("essHMC")) break block13;
                bl2 = true;
                try {
                    File file = new File("/opt/esshmc/data/hmclabmode");
                    if (file.exists()) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "-- exception in getMMTaskEnableState(), e1 is <" + exception + ">");
                    }
                }
            }
            catch (IOException iOException) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "IOException caught accessing hmcType file: " + iOException.getMessage());
                }
            }
            catch (SecurityException securityException) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "SecurityException caught accessing hmcType file: " + securityException.getMessage());
                }
            }
            catch (Exception exception) {
                if (2 > Trace.LEVEL) break block13;
                Trace.trace(TRACE_MASKF, "-- exception in getMMTaskEnableState(), e is <" + exception + ">");
            }
        }
        if (bl2 && !bl) {
            bl3 = Boolean.FALSE;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- RemoteSupportOverview.getMMTaskEnableState()");
        }
        return bl3;
    }
}

